<?php
/**
 * Created by vm.pl
 * User: Rafał Ignaszewski (rafal@vm.pl)
 * Date: 04.12.13 15:32
 */

namespace VM\PackageGeneratorBundle\Services\Export;


class AbstractStructure
{

    /**
     * @var int
     */
    protected $pageWidth = 0;

    /**
     * @var int
     */
    protected $pageHeight = 0;


    /**
     * @param $width
     * @param $height
     * @return mixed
     */
    public function setPageDimensions($width, $height)
    {
        $this->pageWidth = $width;
        $this->pageHeight = $height;
    }


    /**
     * @param $path
     * @return array
     */
    protected function getSortedListOfFiles($path)
    {
        $DirectoryIterator = new \DirectoryIterator($path);
        $files = array();
        foreach($DirectoryIterator as $fileInfo)
        {
            if($fileInfo->isFile())
            {
                $files[] = $fileInfo->getFilename();
            }
        }
        sort($files);
        return $files;
    }
} 